// sortedList.java
// demonstruje dziaanie listy uporzdkowanej
// uruchomienie programu: C>java SortedListApp
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;                  // dane
   public Link next;                   // nastpny element
// -------------------------------------------------------------
   public Link(long dd)                // konstruktor
      { dData = dd; }
// -------------------------------------------------------------
   public void displayLink()           // wypisanie danych
      { System.out.print(dData + " "); }
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class SortedList
   {
   private Link first;                 // referencja do pierwszego elementu
// -------------------------------------------------------------
   public SortedList()                 // konstruktor
      { first = null; }
// -------------------------------------------------------------
   public boolean isEmpty()            // zwraca true, jeeli lista jest pusta
      { return (first==null); }
// -------------------------------------------------------------
   public void insert(long key)        // wstawianie z zachowaniem porzdku
      {
      Link newLink = new Link(key);    // tworzymy nowy element
      Link previous = null;
      Link current = first;            // zaczynamy na pocztku listy
                                       // dopki nie koniec...
      while(current != null && key > current.dData)
         {                             // ...i key > current...
         previous = current;
         current = current.next;       // ...przechodzimy do nastpnego elementu
         }
      if(previous==null)               // na pocztku listy...
         first = newLink;              // ...first --> newLink
      else                             // nie na pocztku...
         previous.next = newLink;      // ...poprzednik --> newLink
      newLink.next = current;          // newLink --> current
      }  // koniec insert()
// -------------------------------------------------------------
   public Link remove()           // zwraca i usuwa pierwszy element
      {                           // (zakadamy, e lista nie jest pusta)
      Link temp = first;               // zapisujemy pierwszy element
      first = first.next;              // usuwamy go z listy
      return temp;                     // zwracamy go
      }
// -------------------------------------------------------------
   public void displayList()
      {
      System.out.print("Lista (pocztek-->koniec): ");
      Link current = first;       // zaczynamy od pocztku
      while(current != null)      // dopki nie koniec...
         {
         current.displayLink();   // ...wypisujemy zawarto...
         current = current.next;  // ...i przechodzimy do nastpnego
         }
      System.out.println("");
      }
   }  // koniec klasy SortedList
////////////////////////////////////////////////////////////////
class SortedListApp
   {
   public static void main(String[] args)
      {                            // tworzymy list
      SortedList theSortedList = new SortedList();
      theSortedList.insert(20);    // wstawiamy dwa elementy
      theSortedList.insert(40);

      theSortedList.displayList(); // wypisujemy zawarto listy

      theSortedList.insert(10);    // wstawiamy kolejne trzy
      theSortedList.insert(30);
      theSortedList.insert(50);

      theSortedList.displayList(); // wypisujemy zawarto listy

      theSortedList.remove();      // usuwamy element

      theSortedList.displayList(); // wypisujemy zawarto listy
      }  // koniec main()
   }  // koniec klasy SortedListApp
////////////////////////////////////////////////////////////////
